/*
 *  test - sceanraio
 *
 *  tested with nightly r6336, pak128 2.2.0 r1142
 *  Can NOT be used in network game !
 */

const version = 0                             // version of script
map.file = "test.sve"                         // specify the savegame to load
scenario.short_description = "test"
scenario.author            = "ny911 (map & scripting)"
scenario.version           = "0." + (version + 1)
scenario.translation      <- "de=ny911"

const startcash = 1                           // pl=0 startchash in millions
const max_x = 1000                            // max. size of map
const forget_time = 12                        // month to forget one terraforming
const city_growth = 500                       // min. year city growth for extra forget terraforming
const target_pax = 90                         // game target PAX
const target_wholesale = 1000                 // target consumption (best 9000)
const traffic_level = 10                      // traffic level
const name_concrete = "Concrete"              // internal name of good
const name_steel = "Stahl"                    // internal name of good
const name_planks = "Bretter"                 // internal name of good

city_pos <- {x = 31, y = 83}                  // position of the biggest city
persistent.max_terra <- 4 * forget_time       // max. terra forming actions
persistent.citylist <- {}                     // table to save terraforming amount
persistent.wholesale <- {}                    // future list of wholesales in game
persistent.tunnel_max <- 0                    // max rock pressure in level at start=0
persistent.counter <- 0                       // stores the loops in each month
persistent.last_month <- -1                   // stores lastmonth default -1
persistent.version <- version                 // stores version of script
persistent.citizen <- 0                       // stores citizens at startgame time


function get_info_text(pl)
{
        return "Info"
}


function get_rule_text(pl)
{
        return "rules ..."
}


function get_goal_text(pl)
{
        return "Service Rate of X% in City XYZ"
}


function get_result_text(pl)
{
        local text = "TEST SCRIPT<br>"
        text+= "Target PAX:" + target_pax + "%<br>"
        text+= "Scenario is up to " + get_percentage() + "% complete.<br><br>"
        local citynr = 0
        local cities = [": "]
        foreach (city in city_list_x() )
                {
                 citynr = city.get_pos().x * max_x + city.get_pos().y
                 local count = 0
                 if (citynr in persistent.citylist)
                    { count = persistent.citylist.rawget(citynr) }
                 cities.append( city.get_name() + ":"
                                + "<a href=\"(" + city.get_pos().x + "," + city.get_pos().y + ")\">" + city.get_name() + "</a> "
                                + round_up(count,forget_time) + "/" + count + "<br>")
                }
        cities.sort()                              //  sort the list
        foreach (row in cities) text+= row.slice(row.find(":")+1)  //  array to string
        text+= "<br>Right now the depths limit for tunnels is " + persistent.tunnel_max + " levels rock pressure."
        text+= "<br><br>"
        text+= "Target wholesale:"+target_wholesale+"<br>"
        text+= "List of material wholesales with consumed goods of last twelve month (concrete/steel/planks)<br><br>"
        foreach (consumer in persistent.wholesale)
                {
                 local factory = factory_x(consumer.pos.x,consumer.pos.y)
                 local concrete = factory.input[name_concrete].get_consumed().reduce(sum)
                 local steel = factory.input[name_steel].get_consumed().reduce(sum)
                 local planks = factory.input[name_planks].get_consumed().reduce(sum)
                 local h = "(" + consumer.pos.x + "," + consumer.pos.y + ")"
                 text+= " <a href=\"" + h + "\">" + translate(factory.get_name()) + "</a> "
                 text+= ttext("near") + " " + consumer.cityname
                 text+= " (" + concrete+"/"+steel+"/"+planks + ")<br>"
                }
        return text
}


function get_about_text(pl)
{
        local about = ttextfile("about.txt")
        about.short_description = scenario.short_description
        about.version = scenario.version
        about.author = scenario.author
        about.translation = scenario.translation
        return about
}


function start()
{
        persistent.citizen = world.get_citizens()[0]
        player_x(0).book_cash( ( (startcash * 1000000) - player_x(0).get_cash()[0]) * 100)
        // make list of all 'material wholesale' in the game
        foreach (position in factory_list_x() )
            {
             local factory = factory_x(position.x,position.y)
             if (factory.output.len() == 0)        //  get last consumer
                  {
                   local s = ","
                   foreach (good, slot in factory.input) s+= good + ","
                   if ( (s.find(name_concrete) != null) && (s.find(name_steel) != null) )
                        {
                         local n = position.x * max_x + position.y
                         local h = {}
                         h.pos <- position
                         h.cityname <- world.find_nearest_city(position).get_name()
// Erzeugt FEHLER
                         persistent.wholesale.rawset(n,h)
                        }
                  }
            }
        resume_game()
}


function round_up(a,b)
{
        local c = (a / b).tointeger()
        if (c * b != a) { c++ }
        return c
}


function sum(a,b)
{
        return a+b
}


function is_scenario_completed(pl)
{
        if (pl != 0) return 0                        // other player get only 0%
        persistent.counter++
        if (persistent.last_month != world.get_time().month)
            {
             persistent.last_month = world.get_time().month
             persistent.counter = 0                  // new month, set counter = 0
            }
        if (persistent.counter == 2) forget_terra_forming()
        if (persistent.counter == 3) check_wholesale()
        return get_percentage()
}


function resume_game()
{
        // check for script version and compatibility, then use update
        if ( persistent.version < version )
             { update() }                          // do update old versions
        else { gui.open_info_win() }               // show scenario window
        // correct settings of savegame
        settings.set_industry_increase_every(0)
        settings.set_traffic_level(traffic_level)
        // forbid tools
        local pl = 0
        rules.forbid_tool(pl, tool_restoreslope )
        rules.forbid_tool(pl, tool_lower_land )
        rules.forbid_tool(pl, tool_raise_land )
        // rules.forbid_way_tool(pl, tool_build_way, wt_air)
}



function tunnel_allowed(pos)
{
        // make deep tunnels expansive
        local max = persistent.tunnel_max
        local ground = square_x(pos.x,pos.y).get_ground_tile()
        local deep = ground.z - pos.z
        if ( (deep > max) || (max == 0) )
           {
            local text = ttext("The tunnel has to resist a maximal rock pressure of {deep} levels. The construction materials are best until {max} Levels.")
            text.max = max
            text.deep = deep
            return text.tostring()
           }
        return null
}


function terra_forming_allowed(pos)
{
        // don't care about underground slopes
        local ground = square_x(pos.x,pos.y).get_ground_tile()
        local deep = ground.z - pos.z
        if (deep != 0) return null
        // nearest city
        local city = world.find_nearest_city( pos )
        local citynr = city.get_pos().x * max_x + city.get_pos().y
        local text = ""
        local count = 0
        if (citynr in persistent.citylist)
            { count = persistent.citylist.rawget(citynr) }
        if (count+forget_time > persistent.max_terra)
               {
                text = ttext( "Citizens of {city} don't like any more terra forming. {counter} / {max}")
                text.city = city.get_name()
                text.counter = round_up(count,forget_time)
                text.max = persistent.max_terra / forget_time
                return text.tostring()
               }
        count+= forget_time
// Erzeugt FEHLER
        persistent.citylist.rawset(citynr, count)
        text = ttext( "Terra forming near of City {city}: {counter} / {max} | {deep}")
        text.deep = deep
        text.city = city.get_name()
        text.max = persistent.max_terra / forget_time
        text.counter = round_up(count,forget_time)
        gui.add_message( text.tostring() )
        return null
}


function forget_terra_forming()
{
        foreach (city in city_list_x() )    // do forget for each city
               {
                local citynr = city.get_pos().x * max_x + city.get_pos().y
                if (citynr in persistent.citylist)
                   {
                    local counter = persistent.citylist[citynr]
                    // normal forget
                    if (counter > 0) counter--
                    // additional forget if city growth a much
                    if ( (counter > 0) && (city.get_growth().reduce(sum) > city_growth ) )
                         counter--
                    persistent.citylist[citynr] = counter
                   }
               }
}


function check_wholesale()
{
        persistent.tunnel_max == 0
        // check planks consumption for tunnel Levels 1+2
        local planks = 0
        local count = persistent.wholesale.len()
        foreach ( consumer in persistent.wholesale )
               {
                local factory = factory_x(consumer.pos.x,consumer.pos.y)
                local consumed = factory.input[name_planks].get_consumed().reduce(sum)
                if (consumed >= target_wholesale) planks++
               }
        if (planks >= count / 2) persistent.tunnel_max = 1
        if (planks >= count) persistent.tunnel_max = 2
        // check concrete and steel for additional levels
        if (persistent.tunnel_max == 0) return
        foreach ( consumer in persistent.wholesale )
               {
                local factory = factory_x(consumer.pos.x,consumer.pos.y)
                local concrete = factory.input[name_concrete].get_consumed().reduce(sum)
                local steel = factory.input[name_steel].get_consumed().reduce(sum)
                if ( (concrete >= target_wholesale) &&
                     (steel >= target_wholesale) )
                      persistent.tunnel_max++
               }
}


function get_percentage()
{
        local city = city_x(city_pos.x,city_pos.y)
        local pax_generated = city.generated_pax.reduce(sum)
        local pax_transported = city.transported_pax.reduce(sum)
        if (pax_generated == 0) return 0
        local percentage = (pax_transported * 100) / pax_generated
        return min( percentage / target_pax, 100)
}


function is_work_allowed_here(pl, tool_id, pos)
{
        local result = null               // null is equivalent to 'allowed'
        if (tool_id == tool_setslope)     result = terra_forming_allowed(pos)
        if (tool_id == tool_build_tunnel) result = tunnel_allowed(pos)
        return result
}


function update()         // update for older versions
{
 local text = ttext("Savegame has a different {more_info} script version! Maybe, it will work.")
 text.more_info = "(0." + persistent.version + ")"
 gui.add_message( text.tostring() )
 // version 1 : xyz....
}

// END OF FILE