/*
 *  class chapter_01
 *
 *
 *  Can NOT be used in network game !
 */


class tutorial.chapter_01 extends basic_chapter
{
	chapter_name  = "The first train"			// name, not too long
	startcash     = 500000	   				// pl=0 startcash; 0=no reset
	// privat
	target = 168		   				// target amount of wood
	cube1  = { nw={x=41,y=100,z=0}, se={x=56,y=100,z=0} } 	// area for rail track
	cube2  = { nw={x=50,y= 97,z=0}, se={x=50,y=100,z=0} } 	// area for rail track to build depot
	cube3  = { nw={x=41,y= 97,z=0}, se={x=56,y=100,z=0} } 	// big area for rail track
	depot  = {x = 50, y =  97, z = 0}
	posnext= {x = 50, y = 100, z = 0}   	   		// place to klick for next step
	posnext2={x = 49, y =  98, z = 0}    			// place to klick for next step
	halt_a = {x = 42, y = 100, z = 0}   			// station area
	halt_b = {x = 55, y = 100, z = 0}	    		// station area

         function set_goal_text(text)
         {
         	switch(this.step)     		// set placeholder for each step
         	{
         		case 1: text.pos  = this.pos_to_text(posnext)
				break
         		case 2: text.pos2 = this.pos_to_text(posnext2)
				break
         		case 3: text.rect = this.cube_to_text(cube1)
				break
         		case 4: text.rect = this.cube_to_text(cube2)
				break
         		case 5: text.halt = this.pos_to_text(halt_a)
				break
         		case 6: text.halt = this.pos_to_text(halt_b)
				break
         		case 7: text.depot= this.pos_to_text(depot)
				break
         		case 9: {
				text.target = this.target
				text.amount = this.get_reached_target()
				break
				}
		}
                 return text
         }


         function is_chapter_completed(pl)
         {
		if (pl != 0) return 0		// only human player = 0
                 local percentage = 0
		local result = null
		percentage = min( (this.get_reached_target() * 100 / this.target), 100)
		switch (this.step)
		{
			case 3 : if ( this.has_way( wt_rail, cube1 ) )
					this.next_step()
				 break
			case 4 : if ( this.has_way( wt_rail, cube2 ) )
					this.next_step()
				 break
	  		// step 6 and 7 : controll last step halt construction with mouse movement
			case 6 : result = is_station_build( pl, halt_a, good_alias.wood )
				 break
			case 7 : result = is_station_build( pl, halt_b, good_alias.wood )
				 break
		}
		if (result != null)
		{
			this.backward_step()    // go back to last step to build something which is needed
			gui.add_message( result )
		}
                 return percentage
         }


	function is_work_allowed_here(pl, tool_id, pos)
	{
         	local result = null	    			// null is equivalent to 'allowed'
		result = translate("Action not allowed")	// set standard error message
                 switch (this.step)
		{
			case 1: if ( (tool_id == 4096) && (pos.x == posnext.x) && (pos.y == posnext.y) )
                                      result = this.next_step()
				break
			case 2: if ( (tool_id == 4096) && (pos.x == posnext2.x) && (pos.y == posnext2.y) )
                                      result = this.next_step()
				break
			case 3: if ( (tool_id != tool_build_way) || !this.is_inside_cube(pos,cube1.nw,cube1.se) )
                                      result = this.give_ttext("Pleace build railway inside {cube}",cube1)
                                 else result = null	// no next step here, done by is_chapter_completed
				break
			case 4: if ( (tool_id != tool_build_way) || !this.is_inside_cube(pos,cube2.nw,cube2.se) )
				     result = this.give_ttext("Pleace build railway inside {cube}",cube2)
                                 else result = null	// no next step here, done by is_chapter_completed
				break
			case 5: if ( (tool_id != tool_build_station) || (pos.x != halt_a.x) || (pos.y != halt_a.y) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_a)
				else result = this.next_step()
				break
			case 6: if ( (tool_id != tool_build_station) || (pos.x != halt_b.x) || (pos.y != halt_b.y) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_b)
				else result = this.next_step()
				break
			case 7: if ( (tool_id != tool_build_depot) || (pos.x != depot.x) || (pos.y != depot.y) )
				     result = this.give_ttext("Pleace build the rail depot at {pos}",depot)
				else result = this.next_step()
				break
			default:result = null
		}
		if (tool_id == 4096) result = null	// it's the standard tool; allow it allways
		if ( (this.step > 4) && (tool_id == tool_build_way) )
			if ( this.is_inside_cube(pos,cube3.nw,cube3.se) )
				result = null		// allow late track correction
		if ( (tool_id == tool_remover) && (this.step == 5 || this.step == 6) )
		{
			local h = halt_a
			if (this.step == 6) h = halt_b
			if ( (this.my_tile(h).get_halt() != null) &&
			     (pos.x == h.x) && (pos.y == h.y) && (pos.z == h.z) )
				result = null		// remove allowed only for stations
		}
                 return result
	}


	function is_schedule_allowed(pl, schedule)
	{
         	local result = null	// null is equivalent to 'allowed'
		local halt   = null
		local halt2  = null
		if ( (pl == 0) && (schedule.waytype != wt_rail) )
			result = translate("Only railway schedules allowed")
		if ( (pl == 0) && (this.step < 9) )
		{
			if ( schedule.entries.len() != 2 )
				return translate("The schedule needs to have two waystops")
			if (result == null)
				result = is_waystop_correct(pl,schedule,0,100,0,halt_a)
			if (result == null)
				result = is_waystop_correct(pl,schedule,1,0,0,halt_b)
		}
		if ( (result == null) && (this.step == 8) )	// schedule okay & step=8, than next step
			this.next_step()
         	return result
	}


         function set_all_rules(pl)	// set all forbid ruls and tools
         {
		local forbid = [tool_build_way,tool_build_bridge,tool_build_tunnel,tool_build_station,tool_remove_way,tool_build_depot,tool_build_roadsign,tool_build_wayobj]
		foreach(wt in all_waytypes)
			if (wt != wt_rail)
			{
				foreach (tool_id in forbid)
					rules.forbid_way_tool(pl, tool_id, wt )
			}
		local forbid = [tool_build_wayobj,tool_build_tunnel,tool_build_bridge,tool_build_roadsign]
		foreach (tool_id in forbid)
			rules.forbid_way_tool(pl, tool_id, wt_rail )
		// tool "climate zones" = 4135
		local forbid = [4135,tool_lower_land,tool_raise_land,tool_setslope,tool_restoreslope,tool_make_stop_public,tool_build_transformer]
		foreach (tool_id in forbid)
			rules.forbid_tool(pl, tool_id )
	}


         function get_reached_target()
         {
		local factory = factory_x(factory_list.sawmill.x, factory_list.sawmill.y)
		return factory.input[good_alias.wood].get_received().reduce(sum)
	}
}        // END of class

// END OF FILE