#!/usr/local/bin/python
import os, sys
import hashlib

def md5file(fileName, excludeLine="", includeLine=""):
    """Compute md5 hash of the specified file"""
    m = hashlib.md5()
    try:
        fd = open(fileName,"rb")
    except IOError:
        print("Unable to open the file in readmode:", filename)
        return
    content = fd.readlines()
    fd.close()
    for eachLine in content:
        if excludeLine and eachLine.startswith(excludeLine):
            continue
        m.update(eachLine)
    m.update(includeLine)
    return m.hexdigest()


def makeupdate(path):
    """Creates an update with the path"""
    for file in os.listdir(path):
        if os.path.isdir(file):
            makeupdate(path + file + "/")
        else:
            print("{0};{1};{2}".format(path + file, md5file(path + file), download + path + file))

if len(sys.argv)==2:
    download = sys.argv[1]
    makeupdate("./")
else:
    print("Simutrans Update Development Kit")
    print("Syntax: ", sys.argv[0], " DownloadLink")
