﻿using System;
using System.Net;
using System.IO;

namespace hohl.DiffUpdate
{
    public class Download
    {
        /// <summary>
        /// Lädt eine Datei von der angegeben HTTP-Adresse herunter und speichert es an den angegebenen Ausgabeort 
        /// </summary>
        /// <param name="url"></param>
        /// <param name="destination"></param>
        public static void GetFile(string url, string destination)
        {
            // Verbindung zur URL aufbauen
            WebRequest req = WebRequest.Create(url);
            WebResponse response = req.GetResponse();
            Stream stream = response.GetResponseStream();

            // Datei anlegen (und wenn nötig Verzeichnis)
            if (!Directory.Exists(Path.GetDirectoryName(destination)))
                Directory.CreateDirectory(Path.GetDirectoryName(destination));
            FileStream file = File.Create(destination);
            
            // Heruntergeladener Stream in Datei speichern
            int bytes = 0;
            do
            {
                byte[] buffer = new byte[1024];
                bytes = stream.Read(buffer, 0, buffer.Length);
                file.Write(buffer, 0, bytes);
            }
            while (bytes != 0);

            // Streams schließen
            file.Close();
            stream.Close();
        }
    }
}
