﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace SimuUpdate
{
    static class Program
    {
        /// <summary>
        /// Der Haupteinstiegspunkt für die Anwendung.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            if (args.Length > 0)
                Application.Run(new SetupWizard(args));
            else
            {
                OpenFileDialog dialog = new OpenFileDialog();
                dialog.CheckFileExists = true;
                dialog.AutoUpgradeEnabled = true;
                dialog.Filter = "Simutrans Online Update Datei (*.simu;*.update)|*.simu;*.update|Alle Dateien (*.*)|*.*";
                dialog.Multiselect = true;
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    Application.Run(new SetupWizard(dialog.FileNames));
                }
            }
        }
    }
}
