﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using hohl.DiffUpdate;
using System.IO;

namespace SimuUpdate
{
    public partial class SetupWizard : Form
    {
        // Texte für die Wizard Willkommen Seite
        private string wizardText1;
        private string wizardText2;

        /// <summary>
        /// Installiationspfad
        /// </summary>
        public string SetupPath;

        /// <summary>
        /// Name der Update Informations Datei
        /// </summary>
        public string[] updateFileName;
        
        public SetupWizard(string[] files)
        {
            InitializeComponent();

            this.SetupPath = Properties.Settings.Default.SimutransPath;

            this.updateFileName = files;
            this.wizardText1 = lblWizardWelcomeText.Text;
            this.wizardText2 = lblWizardTextSimutransExecutable.Text;
            UpdateWizardTexts();
        }

        /// <summary>
        /// Aktualisiert den Text der im Wizard angezeigt wird.
        /// </summary>
        private void UpdateWizardTexts()
        {
            lblWizardWelcomeText.Text = string.Format(wizardText1, Path.GetFileNameWithoutExtension(this.updateFileName[0]));
            lblWizardTextSimutransExecutable.Text = string.Format(wizardText2, this.SetupPath);
        }

        /// <summary>
        /// Abbrechen Button wurde gedrückt.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// Installieren Button wurde zum ersten Mal gedrückt.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void butForward_Click(object sender, EventArgs e)
        {
            // Button gegen wiederbetätigung sichern
            this.butForward.Enabled = false;
            this.butCancel.Enabled = false;
            this.grpSetupStatus.Visible = true;
            this.Refresh();

            // Installiation durchführen
            foreach (string file in this.updateFileName)
                InstallUpdate(file);

            // Steuerelemente wieder aktivieren
            this.progSetupStatus.Style = ProgressBarStyle.Continuous;
            this.progSetupStatus.Value = 100;
            this.progSetupStatus.UseWaitCursor = false;
            this.lboxSetupStatus.UseWaitCursor = false;
            this.butCancel.Text = "Be&enden";
            this.butCancel.Enabled = true;
            this.lboxSetupStatus.Items.Add(Texts.Complete);
        }

        /// <summary>
        /// Startet ein Update
        /// </summary>
        public void InstallUpdate(string file)
        {
            StreamReader fstream = File.OpenText(file);
            char[] seperators = { '_' };
            Update update = new Update(fstream, SetupPath + Path.GetFileNameWithoutExtension(file).Split(seperators)[0]);
            update.CheckFile += new Update.UpdateEventHandler(OnCheckFile);
            update.UpdateProcessComplete += new Update.UpdateEventHandler(OnUpdateProcessComplete);
            update.DownloadStarted += new Update.UpdateEventHandler(OnDownloadStarted);
            update.DownloadComplete += new Update.UpdateEventHandler(OnDownloadComplete);
            update.FileUpdated += new Update.UpdateEventHandler(OnFileUpdated);
            update.DownloadError += new Update.UpdateErrorHandler(OnDownloadError);
            update.StartUpdate();
        }

        private void OnUpdateProcessComplete(string file)
        {
            this.lboxSetupStatus.Items.Add(Texts.UpdateProcessComplete);
            this.Refresh();
        }

        private void OnCheckFile(string file)
        {
            this.lboxSetupStatus.Items.Add(string.Format(Texts.CheckFile, file));
            this.Refresh();
        }

        private void OnDownloadStarted(string file)
        {
            this.lboxSetupStatus.Items.Add(string.Format(Texts.DownloadStarted, file));
            this.Refresh();
        }

        private void OnDownloadComplete(string file)
        {
            this.Refresh();
        }

        private void OnFileUpdated(string file)
        {
            this.lboxSetupStatus.Items.Add(string.Format(Texts.InstalledFile, file));
            this.Refresh();
        }

        private bool OnDownloadError(string file)
        {
            this.lboxSetupStatus.Items.Add(string.Format(Texts.DownloadError, file));
            this.Refresh();
            return true;
        }

        /// <summary>
        /// Installiationsverzeichnis wechseln
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void lnkChangeSetupDirectory_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.SelectedPath = this.SetupPath;
            dialog.Description = "Bitte wählen Sie ihr Simutrans Installiationsverzeichnis:";
            dialog.ShowNewFolderButton = false;
            if (dialog.ShowDialog(this) == DialogResult.OK)
            {
                string path;
                // Wenn nötig hänge noch ein '\' an den Verzeichnisnamen
                if (dialog.SelectedPath.EndsWith(Path.DirectorySeparatorChar.ToString()) || dialog.SelectedPath.EndsWith(Path.AltDirectorySeparatorChar.ToString()))
                    path = dialog.SelectedPath + Path.DirectorySeparatorChar;
                else
                    path = dialog.SelectedPath;
                this.SetupPath = dialog.SelectedPath + Path.DirectorySeparatorChar;
                // Gewähltes Simutrans Verzeichnis speichern
                Properties.Settings.Default.SimutransPath = dialog.SelectedPath + Path.DirectorySeparatorChar;
                Properties.Settings.Default.Save();
                // Texte aktualisieren
                this.UpdateWizardTexts();
            }
        }
    }
}
